;File:	PCBIOS22.ASM
;Edit date:	86/12/13.
;Serial number 24
;
;	8080 CBIOS for RP/M2 on the IBM PC.
;
;
;	Copyright (c) 1983 by microMethods.
;                             P.O. Box G
;                             Warrenton, Oregon  97146
;
;	Reserved locations.
;
RWBT	EQU	0000H	;warmboot vector
RIOB	EQU	0003H	;Intel iobyte
RDSK	EQU	0004H	;4/user number, 4/current disk
RDOS	EQU	0005H	;RDOS vector
RFCB	EQU	005CH	;Resident file control block
RBUF	EQU	0080H	;Resident record buffer
RTPA	EQU	0100H	;FWA for all user programs
;
;	Assembly constants.
;
VERN	EQU	24 mod 10	;CBIOS revision level
RECSIZ	EQU	80H	;record size
MEMSIZ	EQU	64	;memory size in k bytes
MEMPAG	EQU	MEMSIZ*4	;memory size in pages
BIOSIZ	EQU	3+11+1		;CBIOS size in pages
RDOSIZ	EQU	14		;RDOS size in pages
RCPSIZ	EQU	8		;RCP size in pages
;
;	Disk parameters.
;
;	Host buffer constants.
;
BLKSIZ	EQU	1024	;1k reservation block size
CPMSPT	EQU	32	;RP/M sectors/track
SECMSK	EQU	03	;mask to extract RP/M sector
;
;	NEC uPD70108 (V20) instructions.
;
INT88	EQU	081H	;software interrupt @ 204H
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
;	Ascii character codes.
;
cr	EQU	0DH	;carriage return
lf	EQU	0AH	;line feed
;
;	Assembly options.
;
;
;	Assembler calculated memory map.
;
BIOFWA	EQU	(MEMPAG-BIOSIZ)*100H	;CBIOS fwa
RDOFWA	EQU	BIOFWA-(RDOSIZ*100H)	;RDOS fwa
RCPFWA	EQU	RDOFWA-(RCPSIZ*100H)	;RCP fwa
;
;	Locations in RDOS.
;
RDOSDO	EQU	RDOFWA+17H	;directory ordinal
RDOSCF	EQU	RDOSDO+2	;current function
;
;	RDOS functions.
;
FCNF	EQU	22	;create new file
;
;	Assembly controls.
;
BACKSP	EQU	FALSE
;
;	Locations in CBIOS88.
;
C88FWA	EQU	0FA00H	;CBIOS88 first word address
C88MXB	EQU	C88FWA+8	;max memory disk block number
C88DTS	EQU	C88MXB+2	;date & time in 5 BCD bytes
C88MDR	EQU	C88FWA+19H	;number of floppy drives
C88MSK	EQU	C88FWA+20H	;keyboard character mask
C88TRN	EQU	C88MSK+1	;keyboard char translate table
C88DNT	EQU	C88FWA+2DH	;drive number translate table
PDTA	EQU	C88DTS	;date & time string for PDT
;
	ORG	BIOFWA
;
	JMP	BIOCBT	; 0  complete a coldboot
	JMP	BIOWBT	; 1  process warmboot
	JMP	BIOCST	; 2  get console input status
	JMP	BIOCCI	; 3  console character in
	JMP	BIOCCO	; 4  console character out
	JMP	BIOLCO	; 5  list character out
	JMP	BIOPUN	; 6  punch character out
	JMP	BIORCI	; 7  reader character in
	JMP	BIOHOM	; 8  HOME the disk
	JMP	BIOSEL	; 9  select disk
	JMP	BIOTRK	; A  set track
	JMP	BIOSEC	; B  set sector
	JMP	BIODMA	; C  set disk memory address
	JMP	BIORDR	; D  read disk record
	JMP	DTS	; E  write disk record
	JMP	BIOLST	; F  get printer status
	JMP	BIOSTR	;10  skew sector
	JMP	BIOC88	;11  call CBIOS 88
;
;	BIOWBT - Process warmboot.
;	Set up the jumps at 0000 and 0005,
;	then transfer control to RCP.
;
BIOWBT:	LXI	SP,RBUF
	LXI	B,RCPFWA	;reload RCP & RDOS
	MVI	D,1
	CALL	C88
	CALL	SPZ	;set page zero
	XRA	A
	STA	HSTACT	;reset host buffer
	STA	UNACNT
	LDA	RDSK	;get current disk & user
	MOV	C,A
	JMP	RCPFWA+3
;
;	SPZ - Set up page zero vectors.
;
SPZ:	MVI	A,0C3H
	LXI	H,BIOFWA+3	;set warmboot vector
	STA	RWBT
	SHLD	RWBT+1
;
	LXI	H,RDOFWA+6	;set RDOS entry vector
	STA	RDOS
	SHLD	RDOS+1
	LXI	H,RBUF	;reset DMA
	SHLD	DMAADR
	RET
;
;	MSG - Console message out.
;	Entry	HL = fwa message ending in 00
;
MSG:	MOV	A,M
	ORA	A
	RZ		;If done
;
	PUSH	H
	MOV	C,A	;send next char
	CALL	BIOCCO
	POP	H
	INX	H
	JMP	MSG
;
;	C88 - Call CBIOS88.
;	Entry	 D = function number
;		 (DH to the 8088)
;
BIOC88	EQU	$
C88:	CALLN	INT88
	RET
;
;	BIOCST - Get console input status.
;	Exit	 A = FF if char available
;		   = 00 if no key pressed
;
BIOCST	EQU	$
	MVI	D,2	;get keyboard status
	JMP	C88	;call CBIOS88
;
;	BIOCCI - Console character in.
;	Exit	 A = Ascii character
;
BIOCCI	EQU	$
	CALL	BIOCST	;check console status
	ORA	A
	JZ	BIOCCI	;If no data available
;
	MVI	D,3	;get keyboard char
	CALL	C88	;call CBIOS88
;
;	CBIOS88	gets next keyboard character
;	into AL.
;
	IF	BACKSP
	CPI	7FH
	RNZ		;If not rubout
;
;	Set console no-display flag.
;
	STA	CCOFLG
	ENDIF
	RET
;
;	BIOCCO - Console character out.
;	Entry	 C = Ascii character
;
BIOCCO	EQU	$
	NOP ! NOP ! NOP
	IF	BACKSP
	MOV	A,C
	CPI	7FH
	RZ		;If rubout
;
	LDA	CCOFLG
	ORA	A
	JZ	CCO1	;If no-display OFF
;
	XRA	A
	STA	CCOFLG
	MVI	C,08H	;backspace
	CALL	CCO1
	MVI	C,20H	;space
	CALL	CCO1
	MVI	C,08H	;backspace
CCO1	EQU	$
	ENDIF
;
	MVI	D,4	;video display character
	JMP	C88	;call CBIOS88
;
;	BIOLCO - List character out.
;	Entry	 C = character
;
BIOLCO	EQU	$
	PUSH	B
	MVI	D,10H	;get printer status
	CALL	C88
	ANI	10H	;check printer selected
	POP	B
	JZ	LCO1	;If printer not selected
;
	MVI	D,5	;list char out
	JMP	C88	;call CBIOS88
;
;	Process printer not ready.
;
LCO1:	PUSH	B
	LXI	H,LCOA	;"printer not ready"
	CALL	MSG
	CALL	BIOCCI	;get keyboard response
	CPI	03H
	POP	B
	JZ	0000	;If control-C, warmboot
;
	JMP	BIOLCO
;
LCOA:	DB	'Printer not ready.',cr,lf,0
;
;	BIOLST - Get printer status.
;	Exit	 A = FF if ready for next character
;		   = 00 if not
;
BIOLST	EQU	$
	MVI	D,0FH	;88 get print status
	JMP	C88
;
;	BIOPUN - Character out to punch device.
;	Entry	 C = char
;
BIOPUN	EQU	$
	MVI	D,6
	JMP	C88
;
;	BIORCI - Reader device character in.
;	Exit	 A = char
;		DE = .C88 common area
;
BIORCI	EQU	$
	MVI	D,7
	CALL	C88
	LXI	D,C88FWA
	RET
;
;	Disk parameter header tables.
;
;
;	Unit 0.  5 1/4" floppy disk drive A.
;
DPH0	EQU	$
	DW	0000	;no sector skew
	DW	0	;RDOS data area
	DW	0
	DW	0
	DW	DIRBUF	;directory buffer
	DW	DPBA	;.DPB drive A, set by SEL
	DW	CSTA	;.checksum array
	DW	RBRA	;.RBR drive A
;
;	Unit 1.  5 1/4" floppy disk drive B.
;
	DW	0000	;no sector skew
	DW	0	;RDOS data area
	DW	0
	DW	0
	DW	DIRBUF	;directory buffer
	DW	DPBA	;.DPB drive B, set by SEL
	DW	CSTB	;.checksum array
	DW	RBRB	;.RBR drive B
;
;	Unit 2.  5 1/4" floppy disk drive C.
;
	DW	0000	;no sector skew
	DW	0	;RDOS data area
	DW	0
	DW	0
	DW	DIRBUF	;directory buffer
	DW	DPBA	;.DPB drive C, set by SEL
	DW	CSTC	;.checksum array
	DW	RBRC	;.RBR drive C
;
;	Unit 3.  5 1/4" floppy disk drive D.
;
	DW	0000	;no sector skew
	DW	0	;RDOS data area
	DW	0
	DW	0
	DW	DIRBUF	;directory buffer
	DW	DPBA	;.DPB drive D, set by SEL
	DW	CSTD	;.checksum array
	DW	RBRD	;.RBR drive D
;
;	Unit 4.  Reserved for fixed disk drive.
;
DPH2	EQU	$
	DW	0000	;.skew table
	DW	0,0,0	;RDOS area
	DW	DIRBUF	;directory buffer
	DW	DPBH	;.DPB
	DW	CSTE	;check table
	DW	RBRE	;.RBR
;
;	Unit 12.  Memory disk drive M.
;	Simulated disk drive.
;
DPHM	EQU	$
	DW	0000	;no sector skew
	DW	0	;RDOS data area
	DW	0
	DW	0
	DW	DIRBUF
	DW	DPBM	;.DPB for memory disk
	DW	CSTM	;check table
	DW	RBRM	;RBR for memory drive
;
;	Disk parameter blocks.
;	Disk parameter block for single sided drive.
;
DPBA	EQU	$
	DW	32	;SPT  sectors/track
	DB	 3	;BLS  block shift
	DB	 7	;BLM  block mask
	DB	 0	;EXM  extent mask
	DW	9BH	;DSM  max block number
	DW	63	;DRM  max directory ordinal
	DB	0C0H	;ALB  directory RBR bits
	DB	000H	;
	DW	16	;CKS  checksize
	DW	1	;OFF  system tracks
;
;	Disk parameter block for double sided drive.
;
DPBB	EQU	$
	DW	32	;SPT  sectors/track
	DB	4	;BLS  block shift, 2k
	DB	0FH	;BLM  block mask
	DB	01H	;EXM  extent mask
	DW	9DH	;DSM  max block number
	DW	63	;DRM  max directory ordinal
	DB	80H	;ALB  directory RBR bits
	DB	00H
	DW	16	;CKS  check size
	DW	1	;OFF  system tracks
;
;	Disk parameter block for hard disk.
;
DPBH	EQU	$
	DW	64	;SPT  sectors/track
	DB	4	;BLS  block shift, 2k
	DB	0FH	;BLM  block mask
	DB	01H	;EXM  extent mask
	DW	200H	;DSM  max block number
	DW	1024	;DRM  max directory ordinal
	DB	0F0H	;ALB  directory RBR bits
	DB	00H
	DW	0000	;CKS  check size
	DW	1	;OFF  system tracks
;
;	Disk parameter block for memory disk.
;
DPBM	EQU	$
	DW	32	;SPT  sectors/track
	DB	4	;BLS  block shift, 2k
	DB	0FH	;BLM  block mask
MDEXM	EQU	$
	DB	01H	;EXM  extent mask
MDDSM	EQU	$
	DW	9BH	;DSM  max block number, set by coldboot
	DW	63	;DRM  max directory ordinal
	DB	0C0H	;ALB  directory RBR bits
	DB	000H
	DW	0	;CKS  check size
	DW	1	;OFF  system tracks
;
;	HLA - Set HL = HL + A.
;
HLA:	ADD L ! MOV L,A ! RNC
	INR H ! RET
;
;	ADN - Assign disk drive number.
;	Provide logical to physical drive translation.
;	Entry	 A = logical drive number
;	Exit	 A = physical drive number
;
ADN:	LXI	H,C88DNT	;drive number translate table
	CALL	HLA
	MOV	A,M
	RET
;
;	BIOSEL - Select disk.
;	Entry	 C = logical drive number
;		DE = rotated log-in vector
;	Exit	HL = .DPH for drive C
;		   = 0000 if nonexistent drive
;		     DPH preset for DSDD or SSDD
;
BIOSEL	EQU	$
SEL:	MOV	A,C
	CALL	ADN	;get physical drive number
	STA	SEKDSK
	CPI	'M'-'A'
	LXI	H,DPHM	;memory disk .DPH
	RZ		;If memory disk
;
	LXI	H,0000
	CPI	1	;max drive number
MXDRV	EQU	$-1
	RNC		;If nonexistent drive
;
	LXI	H,DPH0
	ADD A ! ADD A ! ADD A ! ADD A	;*16
	CALL	HLA
	MVI	A,01H	;check log-in vector
	ANA	E
	RNZ		;If drive is logged in
;
;	Process a new disk.
;	Detect single or double sided disk,
;	and point the DPH into the appropriate DPB.
;
	PUSH	H	;save .DPH
	CALL	SPB	;determine SSDD or DSDD
	POP H ! PUSH H
	MVI	A,5*2
	CALL	HLA	;store appropriate .DPB
	MOV	M,E
	INX	H
	MOV	M,D
	POP	H	;return HL=.DPH
	RET
;
;	SPB - Select disk parameter block.
;	Read the boot loader to determine single
;	or double sided disk.
;	Exit	DE = .DPB
;
SPB:	LHLD	DMAADR	;save DMA
	PUSH	H
	LXI	H,DIRBUF
	SHLD	DMAADR
;
	CALL	BIOHOM	;read boot record
	LXI	B,3	;sector number
	CALL	BIOSEC
	CALL	BIORDR
;
	POP	H	;restore DMA
	SHLD	DMAADR
;
	LDA	DIRBUF+7FH
	DCR	A
	LXI	D,DPBA	;single sided DPB
	RNZ		;If single sided disk
;
	LXI	D,DPBB	;double sided DPB
	RET
;
;	PDT - Process date & time stamp.
;	Entry	 C = access type flag
;		   = 1 if directory write
;
PDT:	MOV	A,C
	CPI	1
	RNZ		;If not directory write
;
	LDA	RDOSCF	;RDOS current function
	CPI	FCNF
	RNZ		;If not creating new entry
;
;	Check directory initialized for stamps.
;
	LDA	DIRBUF+60H
	CPI	21H
	RNZ		;If directory not stamped
;
;	Update the date & time stamp.
;
	LDA	RDOSDO	;directory ordinal
	ANI	03H
	MOV	B,A	;*10
	ADD A ! ADD A
	ADD	B
	ADD	A
	INR	A	;point to stamp
	LXI	H,DIRBUF+60H
	CALL	HLA	;HL=.stamp
	LXI	D,PDTA	;current date & time string
	MVI	C,5
PDT1:	LDAX	D
	MOV	M,A
	INX	H
	INX	D
	DCR	C
	JNZ	PDT1	;loop to end of string
;
	MVI	C,1	;restore access flag
	RET
;
;	BIOHOM - HOME the disk.
;
BIOHOM	EQU	$
	LDA	HSTWRT	;check host buffer
	ORA	A
	JNZ	STZ	;If write pending
;
	STA	HSTACT	;mark host inactive
;
STZ:	LXI	B,0000	;set track zero
;
;	BIOTRK - Set track.
;	Entry	BC = track number
;
BIOTRK	EQU	$
	MOV H,B ! MOV L,C
	SHLD	SEKTRK
	RET
;
;	BIOSEC - Set RDOS sector.
;	Entry	BC = translated RP/M sector
;
BIOSEC	EQU	$
	MOV H,B ! MOV L,C
	SHLD	SEKSEC
	RET
;
;	BIOSTR - Sector translate.
;	Apply skew table to RP/M sector.
;
BIOSTR	EQU	$
	MOV H,B ! MOV L,C	;no skew
	RET
;
;	BIODMA - Set disk memory address.
;	Entry	BC = disk memory address
;
BIODMA	EQU	$
	MOV H,B ! MOV L,C
	SHLD	DMAADR
	RET
;
;	SEKCMP - Compare tracks.
;	Entry	HL = track
;	Exit	 Z = true, if same track
;
SEKCMP	EQU	$
	XCHG
	LXI	H,SEKTRK
	LDAX	D
	CMP	M
	RNZ		;If not same track
;
	INX	D
	INX	H
	LDAX	D
	CMP	M
	RET
;
;	BIORDR - Read disk record.
;	Read RP/M record into current DMA.
;	Entry	 C = read type flag
;		   = 1  read directory
;
BIORDR	EQU	$
	MOV	A,C	;set read type
	STA	RDTYPE
	XRA	A	;reset unallocated count
	STA	UNACNT
	INR	A	;set operation=read
	STA	READOP
	STA	RSFLAG	;mark pre-read req'd
	MVI	A,WRUAL	;treat as unallocated
	STA	WRTYPE
	JMP	RWOPER	;go read record
;
;	DTS - Insert directory date & time stamp processing.
;
DTS:	CALL	PDT	;process date & time stamp
;
;	BIOWDR - Write disk record.
;	Write RP/M record from current DMA.
;	Entry	 C = write type flag
;		   = 1  write to directory
;		   = 2  write to new block
;
WRDIR	EQU	1	;directory write
WRUAL	EQU	2	;write to new block
;
BIOWDR	EQU	$
	XRA	A	;clear read flag
	STA	READOP
	MOV	A,C	;check write type
	STA	WRTYPE
	CPI	WRUAL
	JNZ	CHKUNA	;If not write to new block
;
;	Process write to new block.
;
	MVI	A,BLKSIZ/128	;records/block
	STA	UNACNT
	LDA	SEKDSK	;get drive
	STA	UNADSK
	LHLD	SEKTRK	;get track
	SHLD	UNATRK
	LDA	SEKSEC	;get sector
	STA	UNASEC
;
;	Check for write to unallocated sector.
;
CHKUNA	EQU	$
	LDA	UNACNT	;count
	ORA	A
	JZ	ALLOC	;If no unallocated remaining
;
;	More unallocated records remain.
;
	DCR	A	;advance unallocated count
	STA	UNACNT
	LDA	SEKDSK	;check drive
	LXI	H,UNADSK
	CMP	M
	JNZ	ALLOC	;If not same drive
;
;	We have the same drive.
;
	LXI	H,UNATRK	;check track
	CALL	SEKCMP
	JNZ	ALLOC	;If not same track
;
;	Tracks are the same.
;
	LDA	SEKSEC	;check sector
	LXI	H,UNASEC
	CMP	M
	JNZ	ALLOC	;If not same sector
;
;	Same disk, track, and sector.
;	Move to next sector for next operation.
;
	INR	M	;advance unallocated sector
	MOV	A,M	;check end of track
	CPI	CPMSPT	;sectors/track
	JC	NOOVF	;If same track
;
;	Advance to next track.
;
	MVI	M,0	;reset sector
	LHLD	UNATRK	;advance track
	INX	H
	SHLD	UNATRK
;
;	Mark pre-read not required.
;
NOOVF	EQU	$
	XRA	A
	STA	RSFLAG
	JMP	RWOPER	;go write record
;
;	Mark pre-read required.
;
ALLOC	EQU	$
	XRA	A	;clear count
	STA	UNACNT
	INR	A	;mark for pre-read
	STA	RSFLAG
;
;	Read or write the record.
;
RWOPER	EQU	$
	XRA	A	;reset error condition
	STA	ERFLAG
	LDA	SEKSEC	;host sector=RP/M sector/4
	ORA A ! RAR
	ORA A ! RAR
	STA	SEKHST
;
;	Check host buffer.
;
	LXI	H,HSTACT
	MOV	A,M
	MVI	M,1	;mark host active
	ORA	A
	JZ	FILHST	;If host buffer empty
;
;	The host buffer contains active data.
;
;	LDA	READOP
;	MOV	B,A
;	LDA	RDTYPE
;	ANA	B
;	CPI	1
;	JZ	NOMATCH	;If directory read
;
	LDA	SEKDSK
	LXI	H,HSTDSK
	CMP	M
	JNZ	NOMATCH	;If not same disk
;
	LXI	H,HSTTRK
	CALL	SEKCMP
	JNZ	NOMATCH	;If not same track
;
	LDA	SEKHST
	LXI	H,HSTSEC
	CMP	M
	JZ	MATCH	;If same disk, track, & sector
;
;	We are moving to a different host area.
;
NOMATCH	EQU	$
;
;	Send host disk address to CBIOS88.
;
	LDA	HSTWRT
	ORA	A
	CNZ	WHST0	;If host write pending
;
;	We may have to fill the host buffer.
;
FILHST	EQU	$
	LDA	SEKDSK	;set host disk
	STA	HSTDSK
	LHLD	SEKTRK	;set host track
	SHLD	HSTTRK
	LDA	SEKHST	;set host sector
	STA	HSTSEC
	CALL	HDA	;send host disk address
	LDA	RSFLAG	;check pre-read req'd
	ORA	A
	CNZ	READHST	;If pre-read required
;
	XRA	A	;mark no write pending
	STA	HSTWRT
;
;	Copy data to or from the host buffer.
;
MATCH	EQU	$
	LDA	SEKSEC	;mask buffer number
	ANI	SECMSK	;03
	MOV	L,A
	MVI	H,0
	DAD H ! DAD H ! DAD H ! DAD H	;*128
	DAD H ! DAD H ! DAD H
;
;	Calculate starting location in the host buffer.
;
	LXI	D,HSTBUF
	DAD	D
	XCHG
	LHLD	DMAADR	;DMA
	MVI	C,RECSIZ	;RP/M record size
	LDA	READOP	;check direction
	ORA	A
	JNZ	RWMOVE	;If reading disk
;
;	Process write.
;
	MVI	A,1	;mark write pending
	STA	HSTWRT
	XCHG
;
;	Entry	DE = source fwa
;		HL = destination fwa
;		 C = byte count
;
RWMOVE	EQU	$
	LDAX	D	;move RP/M record
	INX	D
	MOV	M,A
	INX	H
	DCR	C
	JNZ	RWMOVE	;loop for 128 bytes
;
	LDA	WRTYPE	;check write type
	CPI	WRDIR
	LDA	ERFLAG
	RNZ		;If not directory operation
;
;	Process directory operation.
;
;	Clear the host buffer for directory operation.
;
	ORA	A
	RNZ		;If error flag set
;
	XRA	A	;mark host written
	STA	HSTWRT
	CALL	WRITEHST
	RET
;
;	CHN - Calculate head number.
;	Entry	HL = seek track
;		 A = host drive number
;	Exit	HL = host physical cylinder
;		 C = head number
;
;	Head = 0
;	If not floppy drive, return
;	Calc 39-seek track
;	If no carry, we are done
;
;	Head = 1
;	Cyl = (39-track)+40
;
CHN:	MVI	C,0	;preset head number
	CPI	'C'-'A'	;floppy drives are A: & B:
	RNC		;If not floppy drive
;
	MVI	B,39	;(tracks/side)-1
	MOV	A,B
	SUB	L
	RNC		;If side 0
;
;	Set side 1, reflect track in 40.
;
	MVI	C,03H	;set side HD=1, H=1
	INR	B
	ADD	B
	MOV	L,A
	RET
;
;	HDA - Send host disk address.
;	HDS - Host disk select.
;
HDA:	LDA	HSTDSK
	MOV	C,A
	MVI	D,9	;88 select disk
	CALL	C88
;
;	HTK - Set host track.
;
	LHLD	HSTTRK
	LDA	HSTDSK
	CALL	CHN	;calc cyl & head
	MOV	A,C
	STA	HSTHDN	;host head number
	SHLD	PHYTRK	;host cylinder
	MOV B,H ! MOV C,L
	MVI	D,0AH	;88 set track
	CALL	C88
;
;	HSC - Set host sector.
;
	LHLD	HSTSEC
	MOV B,H ! MOV C,L
	INX	B	;add 1st sector number
	MVI	D,0BH	;88 set sector
	CALL	C88
;
;	HHD - Set host head number.
;
	LDA	HSTHDN
	MOV	C,A
	MVI	D,11H	;88 set head number
	CALL	C88
;
;	HBA - Set host buffer address.
;
HBA:	LXI	B,HSTBUF
	MVI	D,0CH	;88 set host buffer address
	CALL	C88
	RET
;
;	Add entry for patch equivalent code:
;
WHST0:	CALL	HDA	;send host information
;
;	WRITEHST - Write host sector.
;	Entry	HSTDSK = host drive number
;		HSTTRK = host track number
;		HSTSEC = host sector number
;	Exit	ERFLAG = error flag
;		       = 0 if no error
;
WRITEHST	EQU	$
HBD:	MVI	D,0EH	;host buffer write
	CALL	C88
	STA	ERFLAG
	RET
;
;	READHST - Read host sector.
;	Entry	HSTDSK = host disk drive
;		HSTTRK = host track number
;		HSTSEC = host sector number
;
READHST	EQU	$
HBL:	MVI	D,0DH	;host buffer read
	CALL	C88
	STA	ERFLAG
	RET
;
CCOFLG:	DB	0	;console no-display flag
DMAADR:	DW	0080H	;disk memory address
;
;	Host buffer control area.
;
SEKDSK:	DB	0	;drive number
SEKTRK:	DW	0	;track number
SEKSEC:	DW	0	;sector number
SEKHST:	DW	0	;
;
HSTACT:	DB	0	;host buffer active
HSTWRT:	DB	0	;host write pending
HSTDSK:	DB	0	;host drive number
HSTTRK:	DW	0	;host track
HSTSEC:	DW	0	;host sector
;
UNADSK:	DB	0	;disk number
UNATRK:	DW	0	;track number
UNASEC:	DW	0	;sector number
UNACNT:	DB	0	;unallocated count
READOP:	DB	0	;read/write flag
RSFLAG:	DB	0	;pre-read flag
WRTYPE:	DB	0	;1=directory write
ERFLAG:	DB	0	;error flag
RDTYPE:	DB	0	;1=directory read
PHYTRK:	DW	0	;host cylinder number
HSTHDN:	DB	0	;host head (side) number
;
;	Host buffer.
;
	ORG	($ AND 0FFF0H) + 10H
;
HSTBUF	EQU	$
HSTSIZ	EQU	512
;
;	BIOCBT - Complete a coldboot.
;	Set up the jumps at 0000 and 0005,
;	then transfer control to RCP.
;
BIOCBT:	CALL	SPZ	;set page zero
	MVI	A,0	;preset the iobyte
	STA	RIOB
;
;	Copy parameters from CBIOS88.
;
	LHLD	C88MXB	;set M disk size
	SHLD	MDDSM
;
;	Set extent mask for physical extent size.
;
	MOV	A,H
	ORA	A
	JZ	CBT1	;If RBT bytes, EXM=01
;
;	Set EXM=00 for 1 log ext/phy ext.
;
	MVI	A,00
	STA	MDEXM
;
CBT1:	LDA	C88MDR	;set floppy drive count
	STA	MXDRV
;
	LXI	H,CBTA	;"coldboot"
	CALL	MSG
	NOP ! NOP ! NOP
	MVI	A,0	;select drive A, user 0
	STA	RDSK
	MOV	C,A
	JMP	RCPFWA
;
CBTA:	DB	'* Coldboot RP/M2. V 2',VERN+'0',0
	DB	'Copyright (c) 1985 by microMethods, Inc. '
	DB	'P.O. Box G  Warrenton, Oregon  97146 '
	DS	HSTSIZ-($-HSTBUF)
;
;	Directory buffer.
;
DIRBUF	EQU	$
	DS	128
;
;	Checksum arrays and RBRs.
;
CSTA:	DS	16	;check array drive A
RBRA:	DS	32	;RBR drive A
CSTB:	DS	16	;check array drive B
RBRB:	DS	32	;RBR drive B
CSTM:	DS	0	;check array drive M
RBRM:	DS	32	;RBR drive M
CSTE:	DS	0	;check array drive E (hard disk)
RBRE:	DS	0	;RBR drive E (same space as C & D)
CSTC:	DS	16	;check array drive C
RBRC:	DS	32	;RBR drive C
CSTD:	DS	16	;check array drive D
RBRD:	DS	32	;RBR drive D
	DS	128-($-CSTC)	;remainder hard disk RBR
ENDC80	EQU	$
