;File:	RASM0.ASM
;Edit date:	86/10/04.
;Serial number 6
;
;	RP/M2 8080 Assembler.
;
;	Locations on page 0.
;
RWBT	EQU	0000H	;warmboot vector
RDOS	EQU	0005H	;RDOS vector
RFCB	EQU	005CH	;resident file control block
RBUF	EQU	0080H	;resident sector buffer
RTPA	EQU	0100H	;first word address for user programs
;
;	Symbol table location.
;
STFWA	EQU	3700H	;symbol table first word address
;
	ORG	RTPA
	LXI	SP,STACK	;set stack
	LHLD	RDOS+1
	SHLD	SYMAX		;mark end of symbol table
	JMP	ENDMOD
;
;	Print line buffer.
;
PLBSIZ	EQU	120
PLBFWA	EQU	$
	DS	PLBSIZ
PLBFBP:	DS	1		;buffer pointer
;
;	Scanner area.
;
TOKEN:	DS	1		;current token identification
VALUE:	DS	2		;expression value
ACCLEN:	DS	1		;accumulator character count
ACCSIZ	EQU	64
ACCUM:	DS	ACCSIZ		;token accumulator
;
;	Expression evaluation area.
;
EVALUE:	DS	2		;expression value
;
;	Symbol table processing area.
;
SYTOP:	DW	STFWA		;next available location
SYMAX:	DS	2		;last available location
;
;	Assembler data area.
;
PASSN:	DS	1		;pass number, 0 or 1
HEXPC:	DS	2		;hex fill location counter
LOCCN:	DS	2		;assembler location counter
SYBAS:	DW	STFWA		;symbol table fwa
SYADR:	DS	2		;current symbol entry fwa
;
ENDMOD	EQU	($ AND 0FF00H) + 200H
STACK	EQU	ENDMOD
